/*
 YamCha -- Yet Another Multipurpose CHunk Annotator

 $Id: yamcha.cc,v 1.10 2001/07/08 13:36:44 taku-ku Exp $;

 Copyright (C) 2001  Taku Kudoh <taku-ku.aist-nara.ac.jp>
 All rights reserved.

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public
 License as published by the Free Software Foundation; either
 version 2 of the License, or (at your option) any later verjsion.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; if not, write to the
 Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
*/
#include "param.h"
#include "parser.h"
#include "config.h"
#include "common.h"

// $Id: yamcha.cc,v 1.10 2001/07/08 13:36:44 taku-ku Exp $;

int main (int argc, char **argv) 
{
  try {
    YamCha::Param  param;
    YamCha::Parser parser;
    param.set(argc, argv);
    parser.set(param);

    ostream *ofs = &cout;
    if (param.outputFileName != "") {
      ofs = new ofstream(param.outputFileName.c_str());
      if (! *ofs) {
	cerr << argv[0] << ": " << param.outputFileName 
	     << ": permission denied" << endl;
	exit(EXIT_FAILURE);
      }
    } 

    if (param.inputFileNameList.size()) {
      for (unsigned int i = 0; i < param.inputFileNameList.size(); i++) {
	ifstream ifs(param.inputFileNameList[i].c_str());
	if (! ifs) {
	  cerr << argv[0] << ": " << param.inputFileNameList[i]
	       << ": no such file or directory" << endl;
	  continue;
	}
	parser.parse(ifs, *ofs);
      }
    } else {
      parser.parse(cin, *ofs);
    }

    if (ofs != &cout) delete ofs;
    exit(EXIT_SUCCESS);

  } catch (string &e) {
    cout << e << endl  << endl <<  COPYRIGHT << endl
	 << "`" << PACKAGE << " --help' for more information." << endl;
    exit(EXIT_FAILURE);
  }
}
