/*
 YamCha -- Yet Another Multipurpose CHunk Annotator

 $Id: svm_model.h,v 1.10 2001/06/18 06:03:37 taku-ku Exp $;

 Copyright (C) 2001  Taku Kudoh <taku-ku.aist-nara.ac.jp>
 All rights reserved.

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public
 License as published by the Free Software Foundation; either
 version 2 of the License, or (at your option) any later verjsion.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; if not, write to the
 Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
*/
#ifndef _YAMCHA_MODEL_H
#define _YAMCHA_MODEL_H
#include "stldef.h"

// $Id: svm_model.h,v 1.10 2001/06/18 06:03:37 taku-ku Exp $;

namespace YamCha {

class ModelResult
{
 public:
  string className;
  unsigned int voteScore;
  double distScore;
};

class svmModel
{
private:
  struct _Alpha
  {
    int    id;
    double alpha;
  };

  struct _Unit
  {
    int base;
    unsigned int check;
  };

  struct _Model
  {
    unsigned int pos;
    unsigned int neg;
    double       b;
  };

  // cache
  unsigned int *dotBuf;
  double       *dotCache;

  // result;
  double       *_resultList;
  ModelResult  *resultList;

  // kernel param
  char   version [32];
  char   kernel_type [32];
  unsigned int param_degree;     
  double param_g;
  double param_r;
  double param_s;

  // model param
  unsigned int alphaSize;
  unsigned int svSize;
  unsigned int tableSize;  
  unsigned int dimensionSize;
  unsigned int nonzeroDimensionSize;
  unsigned int readSize;
  _Alpha *alphaList;
  unsigned int *fi;
  int          *table;

  // dic param
  unsigned int doubleArraySize;
  _Unit     *doubleArray;

  // param
  map <string, string> paramHash;
  map <string, int>    class2idHash;

  _Model *modelList;
  unsigned int    modelSize;
  void read_buf(int, void *, size_t);

public:
  unsigned int  classSize;
  char **classList;

  svmModel();
  ~svmModel();

  int readModel(const string &filename);

  ModelResult *classify(char **, unsigned int);

  int getClassId(const string &key) 
  {
    return (class2idHash[key] - 1);
  }

  string& getParam(const string& key)
  {
    return paramHash[key]; 
  }
};
   
}
#endif
