/*
 YamCha -- Yet Another Multipurpose CHunk Annotator

 $Id: parser.h,v 1.7 2001/06/18 06:03:37 taku-ku Exp $;

 Copyright (C) 2001  Taku Kudoh <taku-ku.aist-nara.ac.jp>
 All rights reserved.

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public
 License as published by the Free Software Foundation; either
 version 2 of the License, or (at your option) any later verjsion.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; if not, write to the
 Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
*/
#ifndef _YAMCHA_PARSER_H
#define _YAMCHA_PARSER_H

// $Id: parser.h,v 1.7 2001/06/18 06:03:37 taku-ku Exp $;

#include "stldef.h"
#include "feature_index.h"
#include "param.h"
#include "svm_model.h"

namespace YamCha {

class Parser
{
protected:
  // index of features and tag
  FeatureIndexList featureIndexList;

  // Paramter
  Param param; 

  // SVM model
  svmModel *svm_model;

  // 2x2 matrix for feature (context)
  vector < vector <string> > contextList;
  vector <string> tagList;

  // list for score
  vector <double>            distScoreList;
  vector <double>            marginScoreList;
  vector < vector <double> > allCandidatesScoreList;

  // list for selector mode
  vector <string> featuresList;

  // dummy fields for BOS and EOS 
  vector <string> bosList;
  vector <string> eosList;

  int isReverse; 
  int isParsed;
  int isWriteHeader;
  int isAppendFunc;

  unsigned int columnSize;            // # of column
  char         **modelFeaturesList;   // features buffer
  int          modelFeaturesListSize; // size of features buffer
  char         bos_eos_buf[64];       // BOS or EOS features 

  // virtual function (function pointer)
  int     (Parser::*_parse)  ();
  ostream &(Parser::*_write) (ostream &);
  int     (*selectorFunc)    (Parser *,  int);

  int _parse_parser_mode_normal ();
  int _parse_parser_mode_detail ();
  int _parse_selection_mode ();

  ostream& _write_parser_mode (ostream &);
  ostream& _write_selection_mode (ostream &);

  void reverse ();
  ModelResult *estimateCost (int);

public:
  Parser  (const Param &);
  Parser  ();
  ~Parser ();

  int set (const Param &);
  
  int parse ();
  int parse (istream &is, ostream &os) 
  {
     while  (is >> *this) {
	if  (parse ()) os << *this;
     }
     return 1;
  }

  int addFeature (char *);
  int select (int);
  int setSelector(int (*) (Parser *, int), int append = 0);

  int add (vector <string>&);
  int add (string &);

  int clear ();

  string& getFeature (int, int);
  
  inline string& getTag (int i)
  {
    return const_cast<string &> (tagList[i]);
  } 

  inline unsigned int size () const
  {
    return contextList.size ();
  }

  inline unsigned int row () const
  {
    return contextList.size ();
  }

  inline unsigned int column () const
  {
    return (unsigned int)columnSize;
  }
  
  ostream& write (ostream &os) 
  {
    return  (this->*_write) (os);
  }
   
  istream& read (istream &);
   
  inline string &getModelParam (const string &s)
  {
     return svm_model->getParam (s);
  }

  friend ostream& operator<< (ostream& os, Parser &p)
  {
     return p.write (os);
  }

  friend istream& operator>> (istream& is, Parser &p) 
  {
     return p.read (is);
  }
};

}

#endif
