/*
 YamCha -- Yet Another Multipurpose CHunk Annotator

 $Id: param.h,v 1.9 2001/07/08 13:36:44 taku-ku Exp $;

 Copyright (C) 2001  Taku Kudoh <taku-ku.aist-nara.ac.jp>
 All rights reserved.

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public
 License as published by the Free Software Foundation; either
 version 2 of the License, or (at your option) any later verjsion.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; if not, write to the
 Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
*/
#ifndef _PARAM_H
#define _PARAM_H

#include "feature_index.h"

// $Id: param.h,v 1.9 2001/07/08 13:36:44 taku-ku Exp $;

#define OPTION_INFO "Usage: yamcha [optsions] <files>...\n\
\n\
Parmaters for Parser Mode:\n\
  -m, --model=FILE           use FILE as model file.\n\
  -C, --candidate            estimate tags from the given candidates.\n\
  -f, --output-format=TYPE   set output format to TYPE.\n\
                              0 - print estimated tags only. (default)\n\
                              1 - print estimated tags and their scores.\n\
                              2 - print estimated tags and scores of all candidates.\n\
  -e, --eos-string=STR       set EOS marker to STR.\n\
\n\
Parameters for Selection Mode:\n\
  -F, --feature=PATTERN      set PATTERN for the feature representation.\n\
  -B, --backward             select features from the end of sentence.\n\
\n\
Miscellaneous:\n\
  -o, --output=FILE          set the output file name to FILE.\n\
  -v, --version              show the version of YamCha and exit.\n\
  -h, --help                 show this help and exit.\n\
"
namespace YamCha {

class Param
{
public:
  enum {TAG_ONLY, TAG_WITH_SCORE, TAG_WITH_ALL_SCORE };
  string modelFileName;
  int verbose;
  int withCandidates;
  int isReverse;
  vector <string> inputFileNameList;
  string outputFileName;
  string rcFileName;
  string featureParameter;
  string eosString;

  Param();
  void clear();

  int set(int, char **);
  int set(const string &);
  int set(istream &);

  string getHelp() 
  {
      return string(OPTION_INFO);
  }
};

}

#endif
