/*
 YamCha -- Yet Another Multipurpose CHunk Annotator

 $Id: param.cc,v 1.10 2001/07/08 13:36:44 taku-ku Exp $;

 Copyright (C) 2001  Taku Kudoh <taku-ku.aist-nara.ac.jp>
 All rights reserved.

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public
 License as published by the Free Software Foundation; either
 version 2 of the License, or (at your option) any later verjsion.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; if not, write to the
 Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
*/
#include "param.h"
#include "common.h"

// $Id: param.cc,v 1.10 2001/07/08 13:36:44 taku-ku Exp $;

extern char *optarg;
extern int optind;

static const char *short_options = "m:Cf:F:Bo:e:vh";

static struct option long_options[] = {
  {"model",         required_argument, NULL, 'm'},
  {"candidate",     no_argument,       NULL, 'C'},
  {"output-format", required_argument, NULL, 'f'},
  {"feature",       required_argument, NULL, 'F'},
  {"backward",      no_argument,       NULL, 'B'},
  {"output-file",   required_argument, NULL, 'o'},
  {"eos-string" ,   required_argument, NULL, 'e'},
  {"version",       no_argument,       NULL, 'v'},
  {"help",          no_argument,       NULL, 'h'},
  {NULL, 0, NULL, 0}
};

namespace YamCha {

Param::Param()
{
  clear();
}

void Param::clear()
{
  verbose          = 0;
  withCandidates   = 0;
  isReverse        = 0;
  modelFileName    = "";
  outputFileName   = "";
  rcFileName       = "";
  featureParameter = "";
  eosString        = "EOS";
  inputFileNameList.clear();
}

int Param::set(int argc, char **argv)
{
  optind = 1;
  int optnum = 0;

  try {
    while (1) {
      int opt = getopt_long (argc, argv, short_options, long_options, NULL);
      if (opt == EOF) break;
      
      optnum++;
      switch(opt) {
      case 'm':
	modelFileName = string(optarg);
	break;
      case 'o':
	outputFileName = string(optarg);
	break;
      case 'F':
	featureParameter = string(optarg);
	break;
      case 'f':
	verbose = atoi(optarg);
	if (verbose < TAG_ONLY || verbose > TAG_WITH_ALL_SCORE) {
	  throw string("invalid option for -f (" + string(optarg) + ")");
	}
	break;
      case 'B':
	isReverse = 1;
	break;
      case 'C':
	withCandidates = 1;
	break;
      case 'e':
	eosString = string(optarg);
	break;
      case 'h':
	cout << getHelp();
	exit(EXIT_SUCCESS);
	break;
      case 'v':
	cout << PACKAGE << " of " << VERSION << endl;
	exit(EXIT_SUCCESS);
      default:
	return 0;
      }
    }

    for (int i = optind; i < argc; i++) inputFileNameList.push_back(string(argv[i]));

    return optnum;
  }

  catch (string &e) {
    e = "Param::set():" + e;
    throw e;
    return 0;
  }
}

int Param::set(const string &s)
{
  vector <string> tmp_list;
  if (! split_string(s,"\t ", tmp_list)) return 0;
  int argc = tmp_list.size() + 1;
  char **argv = new char * [argc];

  argv[0] = "Param::set";
  int j = 1;
  for (unsigned int i = 0; i < tmp_list.size(); i++) {
    if (tmp_list[i] == "") continue;
    argv[j++] = const_cast<char *>(tmp_list[i].c_str());
  }
  argc = j;
  int r = set(argc, argv);
  delete [] argv;
  return r;
}

}
