/*
 YamCha -- Yet Another Multipurpose CHunk Annotator

 $Id: feature_index.h,v 1.2 2001/06/18 06:03:37 taku-ku Exp $;

 Copyright (C) 2001  Taku Kudoh <taku-ku.aist-nara.ac.jp>
 All rights reserved.

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public
 License as published by the Free Software Foundation; either
 version 2 of the License, or (at your option) any later verjsion.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; if not, write to the
 Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
*/
#ifndef _YAMCHA_FEATUREINDEX_H
#define _YAMCHA_FEATUREINDEX_H

#include "stldef.h"

namespace YamCha {

extern unsigned int split_string(const string &, const string&, vector <string>&);

class FeatureIndex
{
public:
  int row;
  int col;
};

class FeatureIndexList
{
 private:
  int parse_start_end(const string &, int &, int &, int);

public:
  void clear()
  {
    features.clear();
    tags.clear();
  }

  int setFeature(const string&, const string&); 
  int setFeature(const string&, int);

  vector <FeatureIndex> features;
  vector <int>          tags;
};

}

#endif


