#include "ruby.h"
#include "yamcha.h"

/////////////////////////////////////////////////
//
//  Ruby interface for YamCha
//
//  $Id: YamCha.cc,v 1.6 2001/06/19 03:27:01 taku-ku Exp $;

#ifdef __cplusplus

namespace YamCha {
		
extern "C" {
  static VALUE ParserClass;
  static VALUE YamCha_new(VALUE, VALUE);
  static void  YamCha_destroy(Parser *);
  static VALUE YamCha_add(VALUE, VALUE);
  static VALUE YamCha_parse(VALUE);
  static VALUE YamCha_clear(VALUE);
  static VALUE YamCha_size(VALUE);
  static VALUE YamCha_column(VALUE);

  void Init_YamCha(void);
}

static VALUE
YamCha_new(VALUE self, VALUE pstr)
{
  Check_SafeStr(pstr);
  Param p;
  p.set(string(STR2CSTR(pstr)));
  Parser *parser = new Parser(p);
  return Data_Wrap_Struct(self, 0, (void(*)())YamCha_destroy, parser);
}

static void
YamCha_destroy(Parser *parser)
{
  delete parser;
}

static VALUE
YamCha_add(VALUE self, VALUE str)
{
  Check_SafeStr(str);
  Parser *parser;
  Data_Get_Struct(self, Parser, parser);
  string s = string(STR2CSTR(str));
  int r = parser->add(s);
  return INT2NUM(r);
}

static VALUE 
YamCha_clear(VALUE self)
{
  Parser *parser;
  Data_Get_Struct(self, Parser, parser);
  int r = parser->clear();
  return INT2NUM(r);
}

static VALUE 
YamCha_parse(VALUE self)
{
  Parser *parser;
  Data_Get_Struct(self, Parser, parser);
  parser->parse();
  strstream s;   
  s << *parser;
  char *p = s.str();
  int len = strlen(p);
//  p[len-4] = '\0';
  return rb_str_new2(p);
}

static VALUE 
YamCha_size(VALUE self)
{
  Parser *parser;
  Data_Get_Struct(self, Parser, parser);
  int r = parser->size();
  return INT2NUM(r);
}

static VALUE 
YamCha_column(VALUE self)
{
  Parser *parser;
  Data_Get_Struct(self, Parser, parser);
  int r = parser->column();
  return INT2NUM(r);
}

void
Init_YamCha(void)
{
  ParserClass = rb_define_class("YamCha", rb_cObject);
  rb_define_singleton_method(ParserClass, "new", (VALUE(*)())YamCha_new,     1);
  rb_define_method(ParserClass, "add",        (VALUE(*)())YamCha_add,        1);
  rb_define_method(ParserClass, "parse",      (VALUE(*)())YamCha_parse,      0);   
  rb_define_method(ParserClass, "clear",      (VALUE(*)())YamCha_clear,      0);
  rb_define_method(ParserClass, "size",       (VALUE(*)())YamCha_size,       0);   
  rb_define_method(ParserClass, "row",       (VALUE(*)())YamCha_size,       0);   
  rb_define_method(ParserClass, "column",     (VALUE(*)())YamCha_column,     0);
}
   
}
#endif
