#include <darts.h>
#include <fstream>
#include <string>
#include <vector>
#include <algorithm>

unsigned int split_string(const string &src, const string& key, vector <string>& result)
{
   result.clear();
   int len =  src.size();
   int i = 0; int si = 0;
   while(i < len) {
      while (i < len && key.find(src[i]) != string::npos) { si++; i++; 
      }; // skip beginning spaces
      while (i < len && key.find(src[i]) == string::npos) i++; // skip contents
      result.push_back(src.substr(si,i-si));
      si = i;
   }
   
   return result.size();
}

int progress_bar (const char *title, size_t current, size_t total) 
{
  static char bar[] = "*******************************************";
  static int scale = sizeof(bar) - 1;
  static int prev = 0;

  int cur_percentage  = (int)(100.0 * current/total);
  int bar_len         = (int)(1.0   * current*scale/total);

  if (prev != cur_percentage) {
     printf("%s: %3d%% |%.*s%*s| ", title, cur_percentage, bar_len, bar, scale - bar_len, "");
     if (cur_percentage == 100)  printf("\n");
     else                        printf("\r");
     fflush(stdout);
  }
   
  prev = cur_percentage;

  return 1;
};

int main (int argc, char **argv)
{
  if (argc < 3) {
    cerr << "Usage: " << argv[0] << " File Index" << endl;
    exit(0);
  }

  string file  = argv[argc-2];
  string index = argv[argc-1];

  Darts::DoubleArray da;
  string line;
  vector <string>       strs;
  vector <unsigned int> ids;
  istream *is;
   
  if (file == "-") is = &cin;
  else             is = new ifstream (file.c_str());

  if (! *is) {
    cerr << "Cannot Open: " << file << endl;
    exit(-1);
  }

  vector <string> tmp;
  while (getline(*is, line)) {
     if (2 != split_string(line, "\t ", tmp)) {
	cerr << "Format error : " << line << endl;
	exit(-1);
     }
     ids.push_back (atoi(tmp[0].c_str()));
     strs.push_back (tmp[1]);
  }
  if (file != "-") delete is;

  char **str = new char * [strs.size()];
  int  *id   = new int [strs.size()];
   
  for (unsigned int i = 0; i < strs.size(); i++) {
    str[i] = (char *)strs[i].c_str();
    id[i] = ids[i];
  }

  // make double array
  da.build (strs.size(), str, 0, id, &progress_bar);
  da.save (index.c_str());
   
  delete [] str;
  delete [] id;
  exit(0);
}
